// priority: 50

ServerEvents.commandRegistry(e => {
    let { commands: 命令, arguments: 参数 } = e;
    let 获取生效规则状态 = (个人偏好, 全局设置, 全局锁定) => {
        if (全局锁定) {
            return 全局设置;
        }
        return 个人偏好;
    };
    e.register(
        命令.literal("r")
            .requires(source => source.hasPermission(2))
            .executes(context => {
                let s = context.source.server;
                s.runCommandSilent("reload");
                context.source.sendSuccess(Text.of("正在重载..."), false);
                return 1;
            })
    );
    e.register(
        命令.literal("mdf")
            .executes(上下文 => {
                let s = 上下文.source.server;
                let sDATA = s.persistentData;
                let p = 上下文.source.player;
                if (!p) {
                    上下文.source.sendFailure(Text.of("该指令只能由玩家执行。"));
                    return 0;
                }
                let pDATA = p.persistentData;

                p.tell(Text.of("=== 规则与个人状态查询 ===").gold().bold());

                let 个人难度文本显示 = Text.of("游戏难度: ").blue();
                if (typeof 难度标签键名数组 !== "undefined" && typeof 难度阶段前缀 !== "undefined" && typeof 难度中文名称数组 !== "undefined" && typeof 难度颜色数组 !== "undefined") {
                    let 玩家当前难度键名 = null;
                    for (let 某个标签键 of 难度标签键名数组) { if (p.stages.has(难度阶段前缀 + 某个标签键)) { 玩家当前难度键名 = 某个标签键; break; } }
                    if (玩家当前难度键名) {
                        let 难度索引 = 难度标签键名数组.indexOf(玩家当前难度键名);
                        if (难度索引 !== -1 && 难度索引 < 难度中文名称数组.length && 难度索引 < 难度颜色数组.length) {
                            个人难度文本显示 = 个人难度文本显示.append(Text.of("【").blue()).append(Text.of(难度中文名称数组[难度索引]).color(难度颜色数组[难度索引])).append(Text.of("】").blue());
                        } else { 个人难度文本显示 = 个人难度文本显示.append(Text.of("【").blue()).append(Text.of(玩家当前难度键名).color("gray")).append(Text.of("】").blue()); }
                    } else { 个人难度文本显示 = 个人难度文本显示.append(Text.of("【未设定/默认】").gray()); }
                } else { 个人难度文本显示 = 个人难度文本显示.append(Text.of("【难度系统未配置】").darkGray()); }
                p.tell(个人难度文本显示);

                let 玩家动态阶段列表文本 = Text.of("动态阶段: ").blue();
                if (生物强化全局配置 && 动态阶段优先级 && Array.isArray(动态阶段优先级)) {
                    let 拥有动态阶段 = [];
                    动态阶段优先级.forEach(某个阶段名 => { if (p.stages && typeof p.stages.has === "function" && p.stages.has(某个阶段名)) { 拥有动态阶段.push(某个阶段名); } });
                    if (拥有动态阶段.length > 0) {
                        let 最高有效动态阶段 = 动态阶段优先级.find(某个阶段 => 拥有动态阶段.includes(某个阶段));
                        if (最高有效动态阶段) {
                            let 显示名 = 最高有效动态阶段.startsWith("LV") ? "等级 " + 最高有效动态阶段.substring(2) : 最高有效动态阶段;
                            玩家动态阶段列表文本 = 玩家动态阶段列表文本.append(Text.of("【").blue()).append(Text.of(显示名).color("light_purple")).append(Text.of("】").blue());
                        } else { 玩家动态阶段列表文本 = 玩家动态阶段列表文本.append(Text.of("【无】").gray()); }
                    } else { 玩家动态阶段列表文本 = 玩家动态阶段列表文本.append(Text.of("【无】").gray()); }
                } else { 玩家动态阶段列表文本 = 玩家动态阶段列表文本.append(Text.of("【动态阶段系统未配置】").darkGray()); }
                p.tell(玩家动态阶段列表文本);

                let 全局难度与锁定状态文本 = Text.of("全局游戏难度: ").blue();
                if (typeof 难度标签键名数组 !== "undefined" && typeof 难度中文名称数组 !== "undefined" && typeof 难度颜色数组 !== "undefined") {
                    if (sDATA.contains("difficulty") && 难度标签键名数组.includes(sDATA.getString("difficulty"))) {
                        let 全局难度键 = sDATA.getString("difficulty");
                        let 全局难度索引 = 难度标签键名数组.indexOf(全局难度键);
                        if (全局难度索引 !== -1 && 全局难度索引 < 难度中文名称数组.length && 全局难度索引 < 难度颜色数组.length) {
                            全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of("【").blue()).append(Text.of(难度中文名称数组[全局难度索引]).color(难度颜色数组[全局难度索引])).append(Text.of("】").blue());
                        } else { 全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of("【").blue()).append(Text.of(全局难度键).color("gray")).append(Text.of("】").blue()); }
                    } else { 全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of("【未设定/默认】").gray()); }
                } else { 全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of("【难度系统未配置】").darkGray()); }
                if (sDATA.contains("difficultyLocked") && sDATA.getBoolean("difficultyLocked")) { 全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of(" (已锁定)").color("red").bold()); }
                else { 全局难度与锁定状态文本 = 全局难度与锁定状态文本.append(Text.of(" (未锁定)").color("green")); }
                p.tell(全局难度与锁定状态文本);

                let 个人动态难度开启 = pDATA.contains("dynamicDifficultyEnabled") ? pDATA.getBoolean("dynamicDifficultyEnabled") : true;
                let 全局动态难度强制 = sDATA.contains("globalDynamicDifficultyForce") && sDATA.getBoolean("globalDynamicDifficultyForce");
                let 全局动态难度强制状态为开启 = 全局动态难度强制 && (sDATA.contains("globalDynamicDifficultyForceState") && sDATA.getBoolean("globalDynamicDifficultyForceState"));
                let 动态难度开关文本 = Text.of("动态难度开关: ").blue();
                if (全局动态难度强制) {
                    if (全局动态难度强制状态为开启) { 动态难度开关文本 = 动态难度开关文本.append(Text.of("【全局强制开启】").color("light_purple").bold()); }
                    else { 动态难度开关文本 = 动态难度开关文本.append(Text.of("【全局强制关闭】").color("dark_purple").bold()); }
                } else {
                    if (个人动态难度开启) { 动态难度开关文本 = 动态难度开关文本.append(Text.of("【个人开启】").color("green")); }
                    else { 动态难度开关文本 = 动态难度开关文本.append(Text.of("【个人关闭】").color("red")); }
                    动态难度开关文本 = 动态难度开关文本.append(Text.of(" (未全局强制)").gray());
                }
                p.tell(动态难度开关文本);
                let 死亡不掉落默认值 = true;
                let 死亡不掉落状态 = sDATA.contains("keepInventory") ? sDATA.getBoolean("keepInventory") : 死亡不掉落默认值;
                let 死亡掉落文本 = Text.of("死亡不掉落: ").blue().append(Text.of("【").blue());
                if (死亡不掉落状态) { 死亡掉落文本 = 死亡掉落文本.append(Text.of("不掉落").color("green")); }
                else { 死亡掉落文本 = 死亡掉落文本.append(Text.of("会掉落").color("red")); }
                死亡掉落文本 = 死亡掉落文本.append(Text.of("】").blue());
                if (sDATA.contains("keepInventoryLocked") && sDATA.getBoolean("keepInventoryLocked")) { 死亡掉落文本 = 死亡掉落文本.append(Text.of(" (已锁定)").color("red").bold()); }
                else { 死亡掉落文本 = 死亡掉落文本.append(Text.of(" (未锁定)").color("green")); }
                p.tell(死亡掉落文本);
                let 怪物装备默认值 = true;
                let 怪物装备当前启用状态 = sDATA.contains("mobEquipEnabled") ? sDATA.getBoolean("mobEquipEnabled") : 怪物装备默认值;
                let 怪物装备文本 = Text.of("怪物装备: ").blue().append(Text.of("【").blue());
                if (怪物装备当前启用状态) { 怪物装备文本 = 怪物装备文本.append(Text.of("会穿").color("green")); }
                else { 怪物装备文本 = 怪物装备文本.append(Text.of("不穿").color("red")); }
                怪物装备文本 = 怪物装备文本.append(Text.of("】").blue());
                if (sDATA.contains("mobEquipLocked") && sDATA.getBoolean("mobEquipLocked")) { 怪物装备文本 = 怪物装备文本.append(Text.of(" (已锁定)").color("red").bold()); }
                else { 怪物装备文本 = 怪物装备文本.append(Text.of(" (未锁定)").color("green")); }
                p.tell(怪物装备文本);
                let 宝箱锁定_个人默认 = false;
                let 宝箱锁定_全局默认 = false;
                let 宝箱锁定_个人 = pDATA.contains("chestLockingEnabled_personal") ? pDATA.getBoolean("chestLockingEnabled_personal") : 宝箱锁定_个人默认;
                let 宝箱锁定_全局 = sDATA.contains("chestLockingEnabled_global") ? sDATA.getBoolean("chestLockingEnabled_global") : 宝箱锁定_全局默认;
                let 宝箱锁定_已锁定 = sDATA.contains("chestLockingLocked") && sDATA.getBoolean("chestLockingLocked");
                let 宝箱锁定_最终生效 = 获取生效规则状态(宝箱锁定_个人, 宝箱锁定_全局, 宝箱锁定_已锁定);
                let 宝箱锁定文本 = Text.of("宝箱战利品锁定: ").blue().append(Text.of("【").blue());
                if (宝箱锁定_最终生效) { 宝箱锁定文本 = 宝箱锁定文本.append(Text.of("已启用").color("red").bold()); }
                else { 宝箱锁定文本 = 宝箱锁定文本.append(Text.of("已禁用").color("green")); }
                宝箱锁定文本 = 宝箱锁定文本.append(Text.of("】").blue());
                if (宝箱锁定_已锁定) { 宝箱锁定文本 = 宝箱锁定文本.append(Text.of(" (全局规则已锁定)").color("red")); }
                else { 宝箱锁定文本 = 宝箱锁定文本.append(Text.of(" (个人设置有效)").color("aqua")); }
                p.tell(宝箱锁定文本);
                let 刷怪笼损坏_全局默认 = true;
                let 刷怪笼损坏_指令设定值 = sDATA.contains("spawnerDamage_state_byCmd") ? sDATA.getBoolean("spawnerDamage_state_byCmd") : 刷怪笼损坏_全局默认;
                let 刷怪笼损坏_已锁定 = sDATA.contains("spawnerDamage_locked_byCmd") && sDATA.getBoolean("spawnerDamage_locked_byCmd");
                let 刷怪笼损坏_最终生效 = 刷怪笼损坏_指令设定值;
                let 刷怪笼损坏文本 = Text.of("刷怪笼损坏: ").blue().append(Text.of("【").blue());
                if (刷怪笼损坏_最终生效) { 刷怪笼损坏文本 = 刷怪笼损坏文本.append(Text.of("已启用").color("green")); }
                else { 刷怪笼损坏文本 = 刷怪笼损坏文本.append(Text.of("已禁用").color("red")); }
                刷怪笼损坏文本 = 刷怪笼损坏文本.append(Text.of("】").blue());
                if (刷怪笼损坏_已锁定) { 刷怪笼损坏文本 = 刷怪笼损坏文本.append(Text.of(" (已锁定)").color("red").bold()); }
                else { 刷怪笼损坏文本 = 刷怪笼损坏文本.append(Text.of(" (未锁定)").color("green")); }
                p.tell(刷怪笼损坏文本);
                p.tell(Text.of("[点我查询指令帮助]").gold().bold().click({ action: "suggest_command", value: "/mdf 帮助" }));
                return 1;
            })
            .then(命令.literal("帮助")
                .executes(上下文 => {
                    let p = 上下文.source.player; if (!p) return 0;
                    p.tell(Text.of("======= MDF 指令帮助 (OP代表服主权限) =======").color("#FFAA00").bold());
                    p.tell(Text.of("/mdf").aqua().append(Text.of(" - 查看个人状态与服务器规则.").yellow()));
                    p.tell(Text.of("/mdf 帮助").green().append(Text.of(" - 显示此帮助信息.").blue()));
                    p.tell(Text.of("/mdf 功能 伤害显示").aqua().append(Text.of(" - 开/关个人秒伤与总结算显示.").yellow()));
                    p.tell(Text.of("/mdf 规则 难度 <等级>").green().append(Text.of(" - 设定个人难度 (若全局未锁定).").green()));
                    p.tell(Text.of("/mdf 规则 难度 <锁定为 <等级> | 解锁>").aqua().append(Text.of(" - 全局难度锁定/解锁.").blue()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 规则 动态难度开关 <true|false>").green().append(Text.of(" - 个人动态难度 (若未全局强制).").yellow()));
                    p.tell(Text.of("/mdf 规则 动态难度开关 全局 <true|false|unlock>").aqua().append(Text.of(" - 全局强制 开/关/解锁.").blue()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 规则 死亡不掉落 <设定 <true|false> | 锁定 | 解锁>").green().append(Text.of(" - 设置/锁定/解锁.").yellow()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 规则 怪物装备 <设定 <true|false> | 锁定 | 解锁>").aqua().append(Text.of(" - 设置/锁定/解锁.").blue()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 规则 宝箱锁定 <true|false>").green().append(Text.of(" - 个人开启/关闭宝箱战利品锁定 (若全局未锁定).").yellow()));
                    p.tell(Text.of("/mdf 规则 宝箱锁定 全局 <true|false|解锁|enable|disable>").aqua().append(Text.of(" - OP设置/锁定/解锁全局宝箱战利品锁定.").blue()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 规则 刷怪笼损坏 <开启|关闭|锁定为开启|锁定为关闭|解锁>").aqua().append(Text.of(" - OP管理全局刷怪笼损坏逻辑.").blue()).append(Text.of(" (OP)").red()));
                    p.tell(Text.of("/mdf 功能 召唤测试假人").aqua().append(Text.of(" - 在当前位置生成一个用于测试伤害的假人.").blue()));
                    p.tell(Text.of("/mdf 功能 移除测试假人").green().append(Text.of(" - 移除所有由此脚本生成的测试假人.").yellow()));
                    return 1;
                })
            )
            .then(命令.literal("功能")
                .then(命令.literal("伤害显示")
                    .executes(上下文 => {
                        let p = 上下文.source.player; 
                        if (!p) { 
                            上下文.source.sendFailure(Text.of("该指令只能由玩家执行。")); 
                            return 0; 
                        }
                        let pDATA = p.persistentData;
                        let 当前状态 = pDATA.contains("showDamageStats") ? pDATA.getBoolean("showDamageStats") : false;
                        let 新状态 = !当前状态;
                        pDATA.putBoolean("showDamageStats", 新状态);
                        信息(p.stringUuid, "", "dps_clear");
                        信息(p.stringUuid, [], "summary_clear");
                        p.tell(Text.of(新状态 ? "伤害统计显示已开启。" : "伤害统计显示已关闭。").color(新状态 ? "green" : "red"));
                        return 1;
                    })
                )
                .then(命令.literal("召唤测试假人")
                    .executes(上下文 => {
                        let p = 上下文.source.player; if (!p) { 上下文.source.sendFailure(Text.of("该指令只能由玩家执行。")); return 0; }
                        let 当前世界 = p.level; let 目标实体类型 = "minecraft:vindicator"; let 假人 = 当前世界.createEntity(目标实体类型);
                        假人.setPos(p.x, p.y, p.z); 假人.yaw = p.yHeadRot;
                        假人.mergeNbt({ Silent: true, NoAI: true, CanPickUpLoot: false, PersistenceRequired: true, Invulnerable: false, CustomName: "{\"text\":\"测试假人\",\"color\":\"gold\"}", CustomNameVisible: true, Offers: { Recipes: [] }, vindicatorData: { profession: "minecraft:none", level: 1, type: "minecraft:plains" } });
                        假人.persistentData.putBoolean("IsTestDummy", true); 假人.spawn();
                        p.tell(Text.of("已在您的位置召唤测试假人.").color("green")); return 1;
                    })
                )
                .then(命令.literal("移除测试假人")
                    .executes(上下文 => {
                        let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                        let 移除数量 = 0; let 所有世界 = s.allLevels;
                        for (let 单个世界 of 所有世界) {
                            let 世界中的所有实体 = 单个世界.allEntities;
                            for (let 当前实体 of 世界中的所有实体) {
                                if (当前实体.persistentData && typeof 当前实体.persistentData.getBoolean === "function") {
                                    if (当前实体.persistentData.getBoolean("IsTestDummy")) {
                                        当前实体.discard();
                                        移除数量++;
                                    }
                                }
                            }
                        }
                        if (移除数量 > 0) { 上下文.source.sendSuccess(Text.of(`已成功移除 ${移除数量} 个测试假人。`).color("green"), false); }
                        else { 上下文.source.sendSuccess(Text.of("未找到带有 \"IsTestDummy\" 标签的测试假人。").color("yellow"), false); }
                        return 1;
                    })
                )
            )
            .then(命令.literal("规则")
                .then(命令.literal("难度")
                    .then(命令.argument("等级", 参数.INTEGER.create(e))
                        .suggests((提示, 建议) => {
                            if (typeof 难度标签键名数组 !== "undefined" && typeof 难度中文名称数组 !== "undefined" && 难度标签键名数组.length === 难度中文名称数组.length) { for (let i = 0; i < 难度标签键名数组.length; i++) { 建议.suggest(String(i + 1), Text.of(难度中文名称数组[i])); } }
                            else if (typeof 难度标签键名数组 !== "undefined") { for (let i = 0; i < 难度标签键名数组.length; i++) { 建议.suggest(String(i + 1), Text.of(难度标签键名数组[i])); } }
                            return 建议.buildFuture();
                        })
                        .executes(上下文 => {
                            let p = 上下文.source.player; if (!p) { 上下文.source.sendFailure(Text.of("该指令只能由玩家执行。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; } let sDATA = s.persistentData;
                            if (sDATA.contains("difficultyLocked") && sDATA.getBoolean("difficultyLocked")) {
                                let 难度锁定提示 = Text.of("个人难度调整功能当前不可用，因为服务器全局难度已被管理员锁定").color("red");
                                if (sDATA.contains("difficulty") && typeof 难度标签键名数组 !== "undefined" && 难度标签键名数组.includes(sDATA.getString("difficulty")) && typeof 难度中文名称数组 !== "undefined" && typeof 难度颜色数组 !== "undefined") {
                                    let 全局难度键 = sDATA.getString("difficulty");
                                    let 某个难度索引 = 难度标签键名数组.indexOf(全局难度键);
                                    if (某个难度索引 !== -1 && 某个难度索引 < 难度中文名称数组.length && 某个难度索引 < 难度颜色数组.length) { 难度锁定提示 = 难度锁定提示.append(Text.of("为【").color("red")).append(Text.of(难度中文名称数组[某个难度索引]).color(难度颜色数组[某个难度索引])).append(Text.of("】").color("red")); }
                                }
                                难度锁定提示 = 难度锁定提示.append(Text.of("。请联系管理员使用指令 ").color("red")).append(Text.of("/mdf 规则 难度 解锁").gold().click({ action: "suggest_command", value: "/mdf 规则 难度 解锁" })).append(Text.of(" 解锁全局难度后才能调整个人难度。").color("red"));
                                p.tell(难度锁定提示); return 1;
                            }
                            let 等级参数 = 参数.INTEGER.getResult(上下文, "等级");
                            if (typeof 难度标签键名数组 === "undefined" || 等级参数 < 1 || 等级参数 > 难度标签键名数组.length) {
                                p.tell(Text.of(`无效的难度等级，请输入 1 到 ${难度标签键名数组 ? 难度标签键名数组.length : "未知"} 之间的数字。`).color("red")); return 0;
                            }
                            let 选中的难度键名 = 难度标签键名数组[等级参数 - 1];
                            let 选中的难度友好名称 = (typeof 难度中文名称数组 !== "undefined" && 难度中文名称数组.length > 等级参数 - 1) ? 难度中文名称数组[等级参数 - 1] : 选中的难度键名;
                            let 选中的难度颜色 = (typeof 难度颜色数组 !== "undefined" && 难度颜色数组.length > 等级参数 - 1) ? 难度颜色数组[等级参数 - 1] : "blue";
                            if (typeof 设置玩家难度阶段 !== "function") {
                                p.tell(Text.of("错误：设置玩家难度阶段函数 (设置玩家难度阶段) 未定义！").red());
                                console.error("MDF Command Error: 函数 '设置玩家难度阶段' 未定义。");
                                return 0;
                            }
                            设置玩家难度阶段(p, 选中的难度键名);
                            p.tell(Text.of("你已将自己的游戏难度阶段设置为【").append(Text.of(选中的难度友好名称).color(选中的难度颜色)).append(Text.of("】。这不会改变全局游戏规则。")).color("green"));
                            return 1;
                        })
                    )
                    .then(命令.literal("锁定为")
                        .requires(来源 => 来源.hasPermission(2))
                        .then(命令.argument("等级", 参数.INTEGER.create(e))
                            .suggests((提示, 建议) => {
                                if (typeof 难度标签键名数组 !== "undefined" && typeof 难度中文名称数组 !== "undefined" && 难度标签键名数组.length === 难度中文名称数组.length) { for (let i = 0; i < 难度标签键名数组.length; i++) { 建议.suggest(String(i + 1), Text.of(难度中文名称数组[i])); } }
                                else if (typeof 难度标签键名数组 !== "undefined") { for (let i = 0; i < 难度标签键名数组.length; i++) { 建议.suggest(String(i + 1), Text.of(难度标签键名数组[i])); } }
                                return 建议.buildFuture();
                            })
                            .executes(上下文 => {
                                let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                                let p = 上下文.source.player;
                                if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                                else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                                let sDATA = s.persistentData;
                                let 等级参数 = 参数.INTEGER.getResult(上下文, "等级");
                                if (typeof 难度标签键名数组 === "undefined" || 等级参数 < 1 || 等级参数 > 难度标签键名数组.length) {
                                    上下文.source.sendFailure(Text.of(`无效的难度等级，请输入 1 到 ${难度标签键名数组 ? 难度标签键名数组.length : "未知"} 之间的数字。`).color("red")); return 0;
                                }
                                let 选中的难度键名 = 难度标签键名数组[等级参数 - 1];
                                let 选中的难度友好名称 = (typeof 难度中文名称数组 !== "undefined" && 难度中文名称数组.length > 等级参数 - 1) ? 难度中文名称数组[等级参数 - 1] : 选中的难度键名;
                                let 选中的难度颜色 = (typeof 难度颜色数组 !== "undefined" && 难度颜色数组.length > 等级参数 - 1) ? 难度颜色数组[等级参数 - 1] : "blue";
                                sDATA.putString("difficulty", 选中的难度键名);
                                if (typeof 应用游戏规则 === "function") 应用游戏规则(s, 选中的难度键名);
                                if (typeof 设置玩家难度阶段 === "function") {
                                    s.players.forEach(在线玩家 => { 设置玩家难度阶段(在线玩家, 选中的难度键名); });
                                } else {
                                    console.error("MDF Command Error: 函数 '设置玩家难度阶段' 未定义。");
                                    上下文.source.sendFailure(Text.of("错误：设置玩家难度阶段函数未定义，无法同步所有玩家。").red());
                                }
                                sDATA.putBoolean("difficultyLocked", true);
                                let 管理员名称文本 = p.name.copy().color("light_purple");
                                上下文.source.sendSuccess(Text.of("你已将存档全局游戏难度设置为【").append(Text.of(选中的难度友好名称).color(选中的难度颜色)).append(Text.of("】并已锁定。个人难度调整已禁用。所有玩家的游戏难度阶段已同步。")).color("gold"), true);
                                s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已将存档全局游戏难度设置为【").color("aqua")).append(Text.of(选中的难度友好名称).color(选中的难度颜色)).append(Text.of("】并已锁定。所有玩家的游戏难度阶段已同步更新，游戏规则已应用。个人难度调整已禁用。").color("aqua")));
                                return 1;
                            })
                        )
                    )
                    .then(命令.literal("解锁")
                        .requires(来源 => 来源.hasPermission(2))
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            if (!(sDATA.contains("difficultyLocked") && sDATA.getBoolean("difficultyLocked"))) {
                                上下文.source.sendSuccess(Text.of("服务器全局游戏难度当前未锁定。").color("yellow"), true); return 1;
                            }
                            sDATA.putBoolean("difficultyLocked", false);
                            let 管理员名称文本 = p.name.copy().color("light_purple");
                            上下文.source.sendSuccess(Text.of("服务器全局游戏难度已解锁。现在可以通过 /mdf 规则 难度 锁定为 <等级> 重新设定并锁定全局难度，个人难度调整 /mdf 规则 难度 <等级> 也已恢复。").color("green"), true);
                            s.tell(Text.of("管理员 ").color("aqua").append(管理员名称文本).append(Text.of(" 已解锁服务器全局游戏难度。个人难度调整已恢复。").color("aqua")));
                            return 1;
                        })
                    )
                )
                .then(命令.literal("动态难度开关")
                    .then(命令.argument("状态", 参数.STRING.create(e))
                        .suggests((提示, 建议) => { 建议.suggest("true", Text.of("开启个人动态难度")); 建议.suggest("false", Text.of("关闭个人动态难度")); return 建议.buildFuture(); })
                        .executes(上下文 => {
                            let p = 上下文.source.player; if (!p) { 上下文.source.sendFailure(Text.of("该指令只能由玩家执行。")); return 0; }
                            let pDATA = p.persistentData;
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            let 状态参数 = 参数.STRING.getResult(上下文, "状态").toLowerCase();
                            if (sDATA.contains("globalDynamicDifficultyForce") && sDATA.getBoolean("globalDynamicDifficultyForce")) {
                                let 强制状态 = (sDATA.contains("globalDynamicDifficultyForceState") && sDATA.getBoolean("globalDynamicDifficultyForceState")) ? "开启" : "关闭";
                                p.tell(Text.of(`动态难度已被管理员全局强制为【${强制状态}】，个人无法修改。`).color("red"));
                                if (p.hasPermission(2)) {
                                    p.tell(Text.of("作为管理员, 你可以使用 /mdf 规则 动态难度开关 全局 unlock 来解除全局强制。").color("yellow").click({ action: "suggest_command", value: "/mdf 规则 动态难度开关 全局 unlock" }));
                                }
                                return 0;
                            }
                            if (状态参数 === "true") { pDATA.putBoolean("dynamicDifficultyEnabled", true); p.tell(Text.of("你的动态难度已开启。").color("green")); }
                            else if (状态参数 === "false") { pDATA.putBoolean("dynamicDifficultyEnabled", false); p.tell(Text.of("你的动态难度已关闭。").color("red")); }
                            else { p.tell(Text.of("无效的状态参数。请输入 true 或 false。").color("red")); return 0; }
                            return 1;
                        })
                    )
                    .then(命令.literal("全局")
                        .requires(来源 => 来源.hasPermission(2))
                        .then(命令.argument("全局状态", 参数.STRING.create(e))
                            .suggests((提示, 建议) => { 建议.suggest("true", Text.of("全局强制开启动态难度")); 建议.suggest("false", Text.of("全局强制关闭动态难度")); 建议.suggest("unlock", Text.of("解除动态难度全局强制")); return 建议.buildFuture(); })
                            .executes(上下文 => {
                                let p = 上下文.source.player;
                                if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                                else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                                let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                                let sDATA = s.persistentData;
                                let 全局状态参数 = 参数.STRING.getResult(上下文, "全局状态").toLowerCase();
                                let 管理员名称文本 = p.name.copy().color("light_purple");
                                if (全局状态参数 === "true") {
                                    sDATA.putBoolean("globalDynamicDifficultyForce", true);
                                    sDATA.putBoolean("globalDynamicDifficultyForceState", true);
                                    上下文.source.sendSuccess(Text.of("已将全局动态难度强制开启。所有玩家的动态难度将生效。").color("gold"), true);
                                    s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已将全局动态难度强制【开启】。").color("aqua")));
                                    s.players.forEach(在线玩家 => { 在线玩家.tell(Text.of("通知：管理员已全局强制开启动态难度。").color("yellow")); });
                                } else if (全局状态参数 === "false") {
                                    sDATA.putBoolean("globalDynamicDifficultyForce", true);
                                    sDATA.putBoolean("globalDynamicDifficultyForceState", false);
                                    上下文.source.sendSuccess(Text.of("已将全局动态难度强制关闭。所有玩家的动态难度将不生效。").color("gold"), true);
                                    s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已将全局动态难度强制【关闭】。").color("aqua")));
                                    s.players.forEach(在线玩家 => { 在线玩家.tell(Text.of("通知：管理员已全局强制关闭动态难度。").color("yellow")); });
                                } else if (全局状态参数 === "unlock") {
                                    sDATA.putBoolean("globalDynamicDifficultyForce", false);
                                    上下文.source.sendSuccess(Text.of("已解除全局动态难度的强制状态。玩家现在可以自行控制。").color("green"), true);
                                    s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已【解锁】全局动态难度的强制状态。").color("aqua")));
                                } else {
                                    上下文.source.sendFailure(Text.of("无效的全局状态参数。请输入 true, false, 或 unlock。").color("red")); return 0;
                                }
                                return 1;
                            })
                        )
                    )
                )
                .then(命令.literal("死亡不掉落")
                    .requires(来源 => 来源.hasPermission(2))
                    .then(命令.literal("设定")
                        .then(命令.argument("设定值", 参数.BOOLEAN.create(e))
                            .suggests((提示, 建议) => { 建议.suggest("true", Text.of("开启 (不掉落)")); 建议.suggest("false", Text.of("关闭 (会掉落)")); return 建议.buildFuture(); })
                            .executes(上下文 => {
                                let p = 上下文.source.player;
                                if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                                else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                                let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                                let sDATA = s.persistentData;
                                if (sDATA.contains("keepInventoryLocked") && sDATA.getBoolean("keepInventoryLocked")) {
                                    let 当前设定值 = sDATA.contains("keepInventory") ? sDATA.getBoolean("keepInventory") : true;
                                    let 锁定状态文本 = 当前设定值 ? "不掉落" : "会掉落";
                                    let 锁定状态颜色 = 当前设定值 ? "green" : "red";
                                    上下文.source.sendFailure(Text.of("死亡不掉落规则已由管理员锁定为【").color("red").append(Text.of(锁定状态文本).color(锁定状态颜色)).append(Text.of("】，无法修改。请使用指令 ").color("red")).append(Text.of("/mdf 规则 死亡不掉落 解锁").gold().click({ action: "suggest_command", value: "/mdf 规则 死亡不掉落 解锁" })).append(Text.of(" 解锁。").color("red")));
                                    return 1;
                                }
                                let 实际设定值 = 参数.BOOLEAN.getResult(上下文, "设定值");
                                sDATA.keepInventory = 实际设定值;
                                s.runCommandSilent(`/gamerule keepInventory ${实际设定值}`);
                                let 规则文本 = 实际设定值 ? "开启 (不掉落)" : "关闭 (会掉落)";
                                let 规则颜色 = 实际设定值 ? "green" : "red";
                                let 管理员名称文本 = p.name.copy().color("light_purple");
                                上下文.source.sendSuccess(Text.of("你已将死亡不掉落规则设置为：【").append(Text.of(规则文本).color(规则颜色)).append(Text.of("】。")).color("green"), true);
                                s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已将死亡不掉落规则设置为【")).append(Text.of(规则文本).color(规则颜色)).append(Text.of("】。")));
                                return 1;
                            })
                        )
                    )
                    .then(命令.literal("锁定")
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            sDATA.putBoolean("keepInventoryLocked", true);
                            let 当前设定值 = sDATA.contains("keepInventory") ? sDATA.getBoolean("keepInventory") : true;
                            let 规则状态 = 当前设定值 ? "不掉落" : "会掉落";
                            let 规则颜色 = 当前设定值 ? "green" : "red";
                            let 管理员名称文本 = p.name.copy().color("light_purple");
                            上下文.source.sendSuccess(Text.of("死亡不掉落规则【").append(Text.of(规则状态).color(规则颜色)).append(Text.of("】已锁定。")).color("gold"), true);
                            s.tell(Text.of("管理员 ").color("aqua").append(管理员名称文本).append(Text.of(" 已锁定死亡不掉落规则为【").color("aqua")).append(Text.of(规则状态).color(规则颜色)).append(Text.of("】。").color("aqua")));
                            return 1;
                        })
                    )
                    .then(命令.literal("解锁")
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            if (!(sDATA.contains("keepInventoryLocked") && sDATA.getBoolean("keepInventoryLocked"))) {
                                上下文.source.sendSuccess(Text.of("死亡不掉落规则当前未锁定。").color("yellow"), true); return 1;
                            }
                            sDATA.putBoolean("keepInventoryLocked", false);
                            let 管理员名称文本 = p.name.copy().color("light_purple");
                            上下文.source.sendSuccess(Text.of("死亡不掉落规则已解锁。").color("green"), true);
                            s.tell(Text.of("管理员 ").color("aqua").append(管理员名称文本).append(Text.of(" 已解锁死亡不掉落规则。").color("aqua")));
                            return 1;
                        })
                    )
                )
                .then(命令.literal("怪物装备")
                    .requires(来源 => 来源.hasPermission(2))
                    .then(命令.literal("设定")
                        .then(命令.argument("设定值", 参数.BOOLEAN.create(e))
                            .suggests((提示, 建议) => { 建议.suggest("true", Text.of("开启 (会穿)")); 建议.suggest("false", Text.of("关闭 (不穿)")); return 建议.buildFuture(); })
                            .executes(上下文 => {
                                let p = 上下文.source.player;
                                if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                                else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                                let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                                let sDATA = s.persistentData;
                                if (sDATA.contains("mobEquipLocked") && sDATA.getBoolean("mobEquipLocked")) {
                                    let 当前设定值 = sDATA.contains("mobEquipEnabled") ? sDATA.getBoolean("mobEquipEnabled") : true;
                                    let 锁定状态文本 = 当前设定值 ? "会穿" : "不穿";
                                    let 锁定状态颜色 = 当前设定值 ? "green" : "red";
                                    上下文.source.sendFailure(Text.of("怪物装备穿戴规则已由管理员锁定为【").color("red").append(Text.of(锁定状态文本).color(锁定状态颜色)).append(Text.of("】，无法修改。请使用指令 ").color("red")).append(Text.of("/mdf 规则 怪物装备 解锁").gold().click({ action: "suggest_command", value: "/mdf 规则 怪物装备 解锁" })).append(Text.of(" 解锁。").color("red")));
                                    return 1;
                                }
                                let 实际设定值 = 参数.BOOLEAN.getResult(上下文, "设定值");
                                sDATA.mobEquipEnabled = 实际设定值;
                                let 规则文本 = 实际设定值 ? "开启 (会穿)" : "关闭 (不穿)";
                                let 规则颜色 = 实际设定值 ? "green" : "red";
                                let 管理员名称文本 = p.name.copy().color("light_purple");
                                上下文.source.sendSuccess(Text.of("你已将怪物装备规则设置为：【").append(Text.of(规则文本).color(规则颜色)).append(Text.of("】。")).color("green"), true);
                                s.tell(Text.of("管理员 ").append(管理员名称文本).append(Text.of(" 已将怪物装备穿戴规则设置为【")).append(Text.of(规则文本).color(规则颜色)).append(Text.of("】。")));
                                return 1;
                            })
                        )
                    )
                    .then(命令.literal("锁定")
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            sDATA.putBoolean("mobEquipLocked", true);
                            let 当前设定值 = sDATA.contains("mobEquipEnabled") ? sDATA.getBoolean("mobEquipEnabled") : true;
                            let 规则状态 = 当前设定值 ? "会穿" : "不穿";
                            let 规则颜色 = 当前设定值 ? "green" : "red";
                            let 管理员名称文本 = p.name.copy().color("light_purple");
                            上下文.source.sendSuccess(Text.of("怪物装备穿戴规则【").append(Text.of(规则状态).color(规则颜色)).append(Text.of("】已锁定。")).color("gold"), true);
                            s.tell(Text.of("管理员 ").color("aqua").append(管理员名称文本).append(Text.of(" 已锁定怪物装备规则为【").color("aqua")).append(Text.of(规则状态).color(规则颜色)).append(Text.of("】。").color("aqua")));
                            return 1;
                        })
                    )
                    .then(命令.literal("解锁")
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            let s = 上下文.source.server; if (!s) { 上下文.source.sendFailure(Text.of("无法获取服务器实例。")); return 0; }
                            let sDATA = s.persistentData;
                            if (!(sDATA.contains("mobEquipLocked") && sDATA.getBoolean("mobEquipLocked"))) {
                                上下文.source.sendSuccess(Text.of("怪物装备规则当前未锁定。").color("yellow"), true); return 1;
                            }
                            sDATA.putBoolean("mobEquipLocked", false);
                            let 管理员名称文本 = p.name.copy().color("light_purple");
                            上下文.source.sendSuccess(Text.of("怪物装备规则已解锁。").color("green"), true);
                            s.tell(Text.of("管理员 ").color("aqua").append(管理员名称文本).append(Text.of(" 已解锁怪物装备规则。").color("aqua")));
                            return 1;
                        })
                    )
                )
                .then(命令.literal("宝箱锁定")
                    .then(命令.argument("个人状态", 参数.BOOLEAN.create(e))
                        .executes(上下文 => {
                            let p = 上下文.source.player;
                            if (!p) {
                                上下文.source.sendFailure(Text.of("该指令只能由玩家执行。"));
                                return 0;
                            }
                            let sDATA = 上下文.source.server.persistentData;
                            let pDATA = p.persistentData;
                            let 新状态_原始参数 = 参数.BOOLEAN.getResult(上下文, "个人状态");
                            let 新状态;

                            if (新状态_原始参数 != null && typeof 新状态_原始参数.booleanValue === "function") {
                                新状态 = 新状态_原始参数.booleanValue();
                            } else if (typeof 新状态_原始参数 === "boolean") {
                                新状态 = 新状态_原始参数;
                            } else {
                                新状态 = Boolean(新状态_原始参数);
                            }

                            if (sDATA.contains("chestLockingLocked") && sDATA.getBoolean("chestLockingLocked")) {
                                p.tell(Text.of("宝箱锁定规则已被管理员全局锁定，个人无法修改。").color("red"));
                                return 0;
                            }

                            pDATA.putBoolean("chestLockingEnabled_personal", 新状态);

                            let 反馈消息 = `你的个人宝箱战利品锁定偏好已设置为: ${新状态 ? '已启用' : '已禁用'}`;
                            p.tell(Text.of(反馈消息).color(新状态 ? "green" : "red"));

                            return 1;
                        })
                    )
                    .then(命令.literal("全局")
                        .requires(源 => 源.hasPermission(2))
                        .then(命令.argument("全局操作", 参数.STRING.create(e))
                            .suggests((ctx, builder) => {
                                builder.suggest("true", Text.of("全局启用宝箱锁定 (并锁定此设置)"));
                                builder.suggest("false", Text.of("全局禁用宝箱锁定 (并锁定此设置)"));
                                builder.suggest("解锁", Text.of("解除全局锁定 (玩家可自行设置)"));
                                builder.suggest("enable", Text.of("全局启用宝箱锁定 (不锁定)"));
                                builder.suggest("disable", Text.of("全局禁用宝箱锁定 (不锁定)"));
                                return builder.buildFuture();
                            })
                            .executes(上下文 => {
                                let sDATA = 上下文.source.server.persistentData; let 操作 = 参数.STRING.getResult(上下文, "全局操作").toLowerCase(); let 反馈给执行者 = ""; let 反馈给全服 = "";
                                let p = 上下文.source.player;
                                if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                                else if (!p && (操作 === "true" || 操作 === "false" || 操作 === "enable" || 操作 === "disable")) { 上下文.source.sendFailure(Text.of("设置全局状态时需要玩家对象（或从控制台执行）。")); return 0; }

                                if (操作 === "true") {
                                    sDATA.putBoolean("chestLockingEnabled_global", true);
                                    sDATA.putBoolean("chestLockingLocked", true);
                                    反馈给执行者 = "全局宝箱战利品锁定已【启用并锁定】。";
                                    反馈给全服 = `通知：管理员 ${p.name.string} 已全局【启用并锁定】宝箱战利品锁定规则。`;
                                } else if (操作 === "false") {
                                    sDATA.putBoolean("chestLockingEnabled_global", false);
                                    sDATA.putBoolean("chestLockingLocked", true);
                                    反馈给执行者 = "全局宝箱战利品锁定已【禁用并锁定】。";
                                    反馈给全服 = `通知：管理员 ${p.name.string} 已全局【禁用并锁定】宝箱战利品锁定规则。`;
                                } else if (操作 === "解锁") {
                                    sDATA.chestLockingLocked = false;
                                    反馈给执行者 = "全局宝箱战利品锁定已【解除锁定】。玩家可自行设置。";
                                    let 执行者名称 = p ? p.name.string : "控制台";
                                    反馈给全服 = `通知：管理员 ${执行者名称} 已【解除】宝箱战利品锁定规则的全局锁定。`;
                                } else if (操作 === "enable") {
                                    sDATA.putBoolean("chestLockingEnabled_global", true);
                                    sDATA.chestLockingLocked = false;
                                    反馈给执行者 = "全局宝箱战利品锁定已【启用】（允许玩家修改个人设置）。";
                                    反馈给全服 = `通知：管理员 ${p.name.string} 已全局【启用】宝箱战利品锁定规则（允许个人调整）。`;
                                } else if (操作 === "disable") {
                                    sDATA.putBoolean("chestLockingEnabled_global", false);
                                    sDATA.chestLockingLocked = false;
                                    反馈给执行者 = "全局宝箱战利品锁定已【禁用】（允许玩家修改个人设置）。";
                                    反馈给全服 = `通知：管理员 ${p.name.string} 已全局【禁用】宝箱战利品锁定规则（允许个人调整）。`;
                                }
                                else { 上下文.source.sendFailure(Text.of("无效的全局操作。")); return 0; }
                                上下文.source.sendSuccess(Text.of(反馈给执行者).color("gold"), true);
                                if (反馈给全服) 上下文.source.server.tell(Text.of(反馈给全服).color("aqua"));
                                return 1;
                            })
                        )
                    )
                )
                .then(命令.literal("刷怪笼损坏")
                    .then(命令.literal("开启")
                        .executes(上下文 => {
                            let sDATA = 上下文.source.server.persistentData;
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }

                            if (sDATA.contains("spawnerDamage_locked_byCmd") && sDATA.getBoolean("spawnerDamage_locked_byCmd")) {
                                上下文.source.sendFailure(Text.of("刷怪笼损坏已被管理员锁定。").color("red"));
                                return 0;
                            }
                            sDATA.putBoolean("spawnerDamage_state_byCmd", true);
                            sDATA.putBoolean("spawnerDamage_locked_byCmd", false);
                            上下文.source.sendSuccess(Text.of("全局刷怪笼损坏逻辑已【开启】(未锁定)。").color("green"), true);
                            上下文.source.server.tell(Text.of(`通知：玩家 ${p.name.string} 已将全局刷怪笼损坏逻辑【开启】。`).color("aqua"));
                            return 1;
                        })
                    )
                    .then(命令.literal("关闭")
                        .executes(上下文 => {
                            let sDATA = 上下文.source.server.persistentData;
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }

                            if (sDATA.contains("spawnerDamage_locked_byCmd") && sDATA.getBoolean("spawnerDamage_locked_byCmd")) {
                                上下文.source.sendFailure(Text.of("刷怪笼损坏已被管理员锁定。").color("red"));
                                return 0;
                            }
                            sDATA.putBoolean("spawnerDamage_state_byCmd", false);
                            sDATA.putBoolean("spawnerDamage_locked_byCmd", false);
                            上下文.source.sendSuccess(Text.of("全局刷怪笼损坏逻辑已【关闭】(未锁定)。").color("red"), true);
                            上下文.source.server.tell(Text.of(`通知：玩家 ${p.name.string} 已将全局刷怪笼损坏逻辑【关闭】。`).color("aqua"));
                            return 1;
                        })
                    )
                    .then(命令.literal("解锁")
                        .requires(源 => 源.hasPermission(2))
                        .executes(上下文 => {
                            let sDATA = 上下文.source.server.persistentData;
                            if (!(sDATA.contains("spawnerDamage_locked_byCmd") && sDATA.getBoolean("spawnerDamage_locked_byCmd"))) {
                                上下文.source.sendSuccess(Text.of("全局刷怪笼损坏的开关状态当前未锁定。").color("yellow"), true);
                                return 1;
                            }
                            sDATA.putBoolean("spawnerDamage_locked_byCmd", false);
                            let 当前状态 = sDATA.contains("spawnerDamage_state_byCmd") ? sDATA.getBoolean("spawnerDamage_state_byCmd") : true;
                            上下文.source.sendSuccess(Text.of(`全局刷怪笼损坏 (当前为 ${当前状态 ? '开启' : '关闭'}) 已解锁。`).color("green"), true);
                            return 1;
                        })
                    )
                    .then(命令.literal("锁定为开启")
                        .requires(源 => 源.hasPermission(2))
                        .executes(上下文 => {
                            let sDATA = 上下文.source.server.persistentData;
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            sDATA.putBoolean("spawnerDamage_state_byCmd", true);
                            sDATA.putBoolean("spawnerDamage_locked_byCmd", true);
                            上下文.source.sendSuccess(Text.of("全局刷怪笼损坏逻辑已【开启并锁定】。").color("gold"), true);
                            上下文.source.server.tell(Text.of(`通知：管理员 ${p.name.string} 已将全局刷怪笼损坏逻辑【开启并锁定】。`).color("aqua"));
                            return 1;
                        })
                    )
                    .then(命令.literal("锁定为关闭")
                        .requires(源 => 源.hasPermission(2))
                        .executes(上下文 => {
                            let sDATA = 上下文.source.server.persistentData;
                            let p = 上下文.source.player;
                            if (!p && 上下文.source.isPlayer === false) { p = { name: Text.of("控制台") }; }
                            else if (!p) { 上下文.source.sendFailure(Text.of("无法获取玩家对象。")); return 0; }
                            sDATA.putBoolean("spawnerDamage_state_byCmd", false);
                            sDATA.putBoolean("spawnerDamage_locked_byCmd", true);
                            上下文.source.sendSuccess(Text.of("全局刷怪笼损坏逻辑已【关闭并锁定】。").color("gold"), true);
                            上下文.source.server.tell(Text.of(`通知：管理员 ${p.name.string} 已将全局刷怪笼损坏逻辑【关闭并锁定】。`).color("aqua"));
                            return 1;
                        })
                    )
                )
            )
        );
});
